//FREEALL$ JOB (001),'INSTALL FREEALL',CLASS=A,MSGCLASS=A               00010000
//* ********************************************************            00020000
//* *  INSTALL THE 'FREEALL' TSO COMMAND                   *            00030000
//* ********************************************************            00040000
//FREEALL EXEC ASMFCL,COND=(0,NE),                                      00050000
//             MAC1='SYS1.AMODGEN',                                     00060000
//             PARM.ASM='OBJ,NODECK,TERM,LIST',                         00070000
//             PARM.LKED='LIST,MAP,RENT,REUS,REFR'                      00080000
//SYSTERM  DD  SYSOUT=*                                                 00090000
//SYSIN    DD  *                                                        00100000
        TITLE 'FREEALL, FREE ALL DYNAMICALLY ALLOCATED DATASETS(TSO)'
*---------------------------------------------------------------------*
*       FREEALL  ALIAS FA          (NO OPERANDS EXPECTED)             *
*                                                                     *
*       THIS COMMAND PROCESSOR IS USED TO FREE ALL DYNAMICALLY        *
*       ALLOCATED DATA SET WHICH HAVE BEEN ALLOCATED BY A GIVEN TSO   *
*       USER.                                                         *
*                                                                     *
*       IT WILL FREE ALL DATA SET WHICH:                              *
*         1. HAVE BEEN DYNAMICALLY ALLOCATED                          *
*         2. ARE NOT CURRENTLY IN USE.                                *
*         3. ARE NOT CURRENTLY OPEN.                                  *
*         4. ARE NOT ALLOCATED TO DDNAME=SYSPROC OR SYSHELP           *
*         5. ARE NOT ALLOCATED IN A CONCATENATED GROUP                *
*         6. ARE NOT ALLOCATED TO A CATALOG                           *
*         7. ARE NOT ALLOCATED TO DDNAME=ISPPROF        JDM           *
*                                                                     *
*      BASIC LOGIC:                                                   *
*      GET CVT ADDRESS;GET TCB ADDRESS;GET CURRENT JSCB ADDRESS;      *
*      GET POINTER TO QDB; GET POINTER TO DSAB CHAIN FROM QDB;        *
*      FOLLOW DSAB CHAIN LOOKING FOR CANDIDATES TO FREE; WHEN FOUND   *
*      BUILD DAIR (IKJDAP18) PARAMETER LIST AND ISSUE LINK TO IKJDAIR *
*      WHO FREES THE DATA SET; WHEN AT END OF CHAIN TERMINATE.        *
*                                                                     *
*      04DEC80 - CHANGES MADE AT AFDSC/PENTAGON BY BILL GODFREY.      *
*        .  CALL IKJEFF18 TO ANALYZE DAIR FAILURES AND ISSUE MESSAGE. *
*        .  CALL IKJDAIR THRU CVTDAIR INSTEAD OF LINK.                *
*        .  SYSHELP WILL NOT BE FREED                                 *
*        .  ELIMINATE NEED FOR AMODGEN MACROS.                        *
*        .  SYSPRINT AND SYSIN NOT FREED IF TERMINAL.                 *
*      08APR81 - CHANGES MADE AT AFDSC/PENTAGON BY BILL GODFREY.      *
*        .  AFTER EACH UNALLOCATE, GO BACK TO TOP OF DSAB CHAIN.      *
*           THIS MAY SOLVE S0C4 PROBLEM, WHICH POSSIBLY WAS DUE TO    *
*           THE DSAB CHAIN BEING RESTRUCTURED BY UNALLOCATE WHILE     *
*           THE COMMAND CONTINUED TO WALK THE ORIGINAL CHAIN,         *
*           WHICH WAS FREEMAINED BY UNALLOCATE.                       *
*           TO AVOID AN ENDLESS LOOP, ANY TIME IKJDAIR FAILS          *
*           TO UNALLOCATE, WE SAVE THE DDNAME IN A TABLE SO WE        *
*           WONT TRY TO UNALLOCATE IT AGAIN THE NEXT TIME WE          *
*           COME DOWN THE CHAIN.                                      *
*        .  REMOVED TEST FOR MEMBER-OF-CONCATENATION.  CONCATENATED   *
*           DATA SETS WERE NOT BEING FREED.                           *
*                                                                     *
*      24MAR83 - CHANGES MADE AT SAN ANTONIO DATA SERVICES CENTER     *
*           BY JIM MARSHALL(JDM), DO NOT TRY TO FREE DDNAME=ISPPROF   *
*                                                                     *
*      23MAY90 - PROBLEM REPORTED TO ME ABOUT GETTING DAIR ERR        *
*                X'00000004', SOLVED BY PUTTING TEST BACK IN FOR      *
*                CONCATENATION.                               JDM1    *
*                                                                     *
*      24MAY90 - WILL CLEANUP CODE AND TRY TO UNDERSTAND IT AND PUT   *
*                MACROS BACK IN.                              JDM2    *
*                                                                     *
*      26MAY90 - QDB AND DSAB CHAINING AND SEARCHING SEEMS TO BE      *
*                DONE WITH "SMOKE AND MIRRORS" (EXPLAIN IT)   JDM3    *
*                                                                     *
*---------------------------------------------------------------------*
         SPACE
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         SPACE
FREEALL  CSECT
         B     @PROLOG-*(,R15)
         DC    AL1(11),CL11'FREEALL'
         DC    CL16' &SYSDATE &SYSTIME '
@PROLOG  STM   R14,R12,12(R13)     SAVE REGS
         LR    R12,R15
         USING FREEALL,R12
         LR    R8,R1
         USING CPPL,R8
         GETMAIN R,LV=LDYNAMIC
         LR    R11,R1
         USING WORKAREA,R11
         LA    R9,SAVEAREA
         ST    R13,SAVEAREA+4
         ST    R9,8(,R13)
         LR    R13,R9
         ST    R8,CPPLPTR          SAVE CPPL ADDRESS
         XC    ERRLIST(ERRLISTL),ERRLIST
         L     R1,CPPLUPT
         L     R2,CPPLECT
         LA    R3,ECB
         L     R4,CPPLPSCB
         LA    R5,DAPB
         DROP  R8                  CPPL
         STM   R1,R5,DAPL
         XC    ECB,ECB
         EJECT
         L     R15,CVTPTR          CVT ADDR                      JDM2
         USING CVTMAP,R15          GET ADDRESSABILITY            JDM2
         L     R15,CVTTCBP         CVTTCBP                       JDM2
         DROP  R15                                               JDM2
         L     R15,4(,R15)         TCB ADDR  (CURRENT TCB)       JDM2
         USING TCB,R15                                           JDM2
         L     R15,TCBJSCB         TCBJSCB                       JDM2
         DROP  R15                                               JDM2
         USING IEZJSCB,R15         GET ADDRESSABILITY            JDM2
         L     R15,JSCDSABQ        QDB FOR DSAB CHAIN            JDM2
         DROP  R15                                               JDM2
         USING QDB,R15             GET ADDRESSABILITY            JDM3
         CLC   QDBNELMS(4),=F'0'   ZERO DATA SETS FOR THIS USER  JDM3
         BE    RETURN              IF HE NONE, WE CANT FREE EM
         L     R2,QDBFELMP         LOAD ADDRESS OF FIRST DSAB    JDM3
         DROP  R15                                               JDM3
         USING DSAB,R2                                           JDM3
INLOOP   EQU   *
         TM    DSABFLG1,DSABDALC   DATA SET DYNAMICALLY ALLOCATED
         BZ    NEXTDSAB            NO, GO LOOK AT NEXT ONE
         TM    DSABFLG1,DSABNUSE   DATA SET IN USE
         BO    NEXTDSAB            YES DONT FREE IT
         TM    DSABFLG1,DSABDCAT+DSABCATM MEMBER OF CONCAT GRP   JDM1
         BNZ   NEXTDSAB            YES DONT FREE IT              JDM1
         TM    DSABFLG3,DSABCATL+DSABJSCT CATALOG OR JOB/STEP CAT
         BNZ   NEXTDSAB            YES DONT FREE IT
         MVI   FMB1,C' '
         MVI   FMB2,C' '
         MVI   FMB3,C' '
         L     R3,DSABTIOT         LOAD ADDRESS OF TIOT ENTRY
         USING TIOENTRY,R3         SET ADDRESSABILITY TO TIOT ENTRY
         MVC   FMDDN,TIOEDDNM      MOVE IN DDNAME FROM TIOT
         CLC   FMDDN,=CL8'SYSPROC' CLIST LIBRARY
         BE    NEXTDSAB            DONT FREE IT
         CLC   FMDDN,=CL8'SYSHELP' HELP LIBRARY
         BE    NEXTDSAB            DONT FREE IT
         CLC   FMDDN,=CL8'ISPPROF' ISPF/PDF PROFILE LIBRARY       JDM
         BE    NEXTDSAB            DONT FREE IT                   JDM
         TM    TIOELINK,TIOTTERM   IS IT A TERMINAL
         BNO    NOTTERM            NO, BRANCH                     JDM2
         CLC   FMDDN,=CL8'SYSIN'   SYSIN
         BE    NEXTDSAB            DONT FREE SYSIN IF TERMINAL
         CLC   FMDDN,=CL8'SYSPRINT' SYSPRINT
         BE    NEXTDSAB            DONT FREE SYSPRINT IF TERMINAL
         MVC   FMDSN(8),=C'TERMFILE'
         B     NOVOL
NOTTERM  EQU   *
         L     R4,TIOEJFCB         LOAD ADDRESS OF JFCB
         SRL   R4,8                SHIFT OFF UNWANTED BYTE
         LA    R4,16(R4)           SKIP OVER PREFIX
         USING INFMJFCB,R4
         MVC   FMDSN,JFCBDSNM      MOVE IN DSNAME
         CLC   JFCBELNM,=CL8' '    MEMBER NAME PRESENT
         BE    NOMBR
         LA    R5,FMDSN            GET START OF DSN
         LA    R6,34               DSN LENGTH - (XXXXXXXX)
MBRLOOP1 EQU   *
         CLI   0(R5),C' '          BLANK FOUND
         BE    MBRBLANK            GOT FIRST BLANK
         LA    R5,1(R5)            INCREMENT ADDRESS
         BCT   R6,MBRLOOP1         GO DO IT AGAIN
MBRBLANK EQU   *
         MVI   0(R5),C'('          MOVE IN L PAREN
         MVC   1(8,R5),JFCBELNM    MOVE IN MEMBER NAME
         LA    R5,2(R5)            SKIP OVER ( AND 1ST CHAR OF MEMBER
         LA    R6,7                MAX LENGTH OF MEMBER NAME
MBRLOOP2 EQU   *
         CLI   0(R5),C' '          BLANK FOUND
         BE    MBREND              GOT BLANK AFTER MEMBER NAME
         LA    R5,1(R5)            INCREMENT INDEX
         BCT   R6,MBRLOOP2         GO FIND END
MBREND   EQU   *
         MVI   0(R5),C')'
NOMBR    EQU   *
         DROP  R4                  JFCB
         MVC   FMVOL,=CL6' '       BLANK VOL SER
         L     R15,TIOEFSRT-1      LOAD UCB ADDRESS              JDM2
         LA    R15,0(R15)          CLEAR HIGH ORDER BYTE         JDM2
         LTR   R15,R15             ZERO ?                        JDM2
         BE    NOVOL
         USING UCBOB,R15           GET ADDRESSABILITY            JDM2
         CLI   UCBTBYT3,UCB3DACC   DIRECT ACCESS DEVICE          JDM2
         BNE   NOVOL               NO, BRANCH
         TM    UCBJBNR,UCBVRDEV    VIO                           JDM2
         BO    NOVOL               YES, BRANCH
         MVC   FMVOL,UCBVOLI       MOVE IN VOL SER               JDM2
         DROP  R15                                               JDM2
NOVOL    EQU   *
         MVC   DAPB(DAPB18L),DAPB18C    INITIALIZE DAPB
         LA    R8,DAPB             MAKE DAIR 18 ADDRESSABLE
         USING DAPB18,R8
         MVC   DA18DDN,TIOEDDNM    MOVE IN DDNAME FROM TIOT
         SPACE
         LA    R1,ERRLIST
         LH    R0,0(,R1)           GET NUMBER OF DDNAMES IN ERRLIST
         LTR   R0,R0               ARE THERE ANY
         BZ    ERRPASS             NO, BRANCH
ERRSCAN  CLC   DA18DDN,0(R1)       DID WE TRY THIS BEFORE AND FAIL
         BE    NEXTDSAB            YES, WONT TRY THAT AGAIN
         LA    R1,8(,R1)           POINT TO NEXT DDNAME IN ERRLIST
         BCT   R0,ERRSCAN          BRANCH IF THERE IS ANOTHER
ERRPASS  EQU   *
         SPACE
         LA    R1,DAPL             ADDRESS OF DAPL
         L     R15,CVTPTR          GET ADDR OF CVT               JDM2
         USING CVTMAP,R15          GET ADDRESSABILITY            JDM2
         CLC   CVTDAIR,=F'0'       IS IKJDAIR IN LPA             JDM2
         BZ    DAIRLINK            IF NOT THEN LINK              JDM2
         L     R15,CVTDAIR         IF SO WE CAN BRANCH ENTER     JDM2
         DROP  R15                                               JDM2
         BALR  R14,R15             CALL DAIR DIRECTLY
         B     DAIRRET
DAIRLINK EQU   *
         LINK  EP=IKJDAIR          FREE DSE
DAIRRET  EQU   *
         LTR   R15,R15             TEST RC
         BNZ   ERROR               FAILED
         MVC   FMTEXT,=CL17'FREED'
         LA    R1,FMMSG            LOAD ADDRESS OF MSG TO TERMINAL
         TPUT  (1),78
         SPACE
         L     R15,CVTPTR          CVT ADDR                      JDM2
         USING CVTMAP,R15          GET ADDRESSABILITY            JDM2
         L     R15,CVTTCBP         CVTTCBP                       JDM2
         DROP  R15                                               JDM2
         L     R15,4(,R15)         TCB ADDR  (CURRENT TCB)       JDM2
         USING TCB,R15                                           JDM2
         L     R15,TCBJSCB         TCBJSCB                       JDM2
         DROP  R15                                               JDM2
         USING IEZJSCB,R15         GET ADDRESSABILITY            JDM2
         L     R15,JSCDSABQ        QDB FOR DSAB CHAIN            JDM2
         DROP  R15                                               JDM2
         USING QDB,R15             GET ADDRESSABILITY            JDM3
         CLC   QDBNELMS(4),=F'0'   ZERO DATA SETS FOR THIS USER  JDM3
         BE    RETURN              IF HE NONE, WE CANT FREE EM
         L     R2,QDBFELMP         LOAD ADDRESS OF FIRST DSAB    JDM3
         DROP  R15                                               JDM3
         LTR   R2,R2
         BNZ   INLOOP
         B     RETURN
NEXTDSAB EQU   *
         L     R2,DSABFCHN         LOAD POINTER TO NEST DSAB ENTRY
         LTR   R2,R2               END OF CHAIN
         BNZ   INLOOP              NO GO DO THE REST OF EM
         DROP  R2,R3               DSAB, TIOENTRY
         SPACE
RETURN   EQU   *
         LR    R1,R13              DYNAMIC AREA ADDR IN R1
         LA    R0,LDYNAMIC         SIZE OF AREA
         L     R13,4(,R13)         PREV SAVE AREA
         LA    R1,0(,R1)           CLEAR HI ORDER
         SVC   10                  FREEMAIN
         LM    14,12,12(13)        RESTORE REGS
         LA    15,0                RETURN CODE
         MVI   12(13),X'FF'        INDICATE RETURN
         BR    R14
         SPACE
ERROR    DS    0H
         LR    R3,R15
         LH    R1,ERRLIST          GET NUMBER OF DDNAMES IN LIST
         LA    R1,1(,R1)           ADD 1
         STH   R1,ERRLIST          STORE NEW NUMBER
         BCTR  R1,0                MINUS 1 TO GET INDEX OF NEW ENTRY
         SLL   R1,3                MULTIPLY BY 8 (LENGTH OF A DDNAME)
         LA    R1,ERRLIST+2(R1)    POINT TO NEW ENTRY
         MVC   0(8,R1),DA18DDN     MOVE DDNAME TO NEW ENTRY
         SPACE
************************************************************
*                                                          *
*        DYNAMIC ALLOCATION FAILURE ROUTINE                *
*                                                          *
************************************************************
         SPACE
DAIRFAIL EQU   *
         MVC   0(8,R1),DA18DDN
         LA    R1,MYDFPARM
         USING DFDSECTD,R1
         ST    R15,MYDFRC          STORE RETURN CODE FROM DAIR
         LA    R15,MYDFRC
         ST    R15,DFRCP           STORE ADDRESS OF RETURN CODE
         LA    R15,DAPL
         ST    R15,DFDAPLP         STORE ADDRESS OF DAPL
         SLR   R15,R15
         ST    R15,MYJEFF02        STORE ZERO IN IKJEFF02 ADDRESS
         LA    R15,MYJEFF02
         ST    R15,DFJEFF02        STORE ADDRESS OF IKJEFF02 (ZERO)
         LA    R15,DFDAIR
         STH   R15,MYDFID          STORE DAIR INDICATOR
         LA    R15,MYDFID
         ST    R15,DFIDP           STORE ADDRESS OF DAIR INDICATOR
         L     R15,CPPLPTR
         ST    R15,DFCPPLP         STORE ADDRESS OF CPPL
         LINK  EP=IKJEFF18
         L     R15,MYDFRC
         DROP  R1                  DFDSECTD
         B     NEXTDSAB            TRY TO CONTINUE
*        TPUT  MSG,50,HOLD,BREAKIN
*        ABEND 400,DUMP
*MSG     DC    CL50'ERROR FROM DAIR, PLEASE SEND DUMP TO SOFTWARE'
         SPACE 3
DAPB18C  DS    0F
         DC    X'0018'             DA18CD
         DC    H'0'                DA18FLG
         DC    H'0'                DA18DARC
         DC    H'0'                DA18CTRC
         DC    A(0)                DA18PDSN
         DC    CL8' '              DA18DDN
         DC    CL8' '              DA18MNM
         DC    CL2' '              DA18SCLS
         DC    X'00'               DA18DSP2
         DC    X'10'               DA18CTL  -  RLSE PERM ALLOC
         DC    CL8' '              DA18JBNM
DAPB18L  EQU   *-DAPB18C           LENGTH
         SPACE
         LTORG                                                   JDM1
         EJECT
************************************************************
*                                                          *
*        WORK SPACE                                        *
*                                                          *
************************************************************
         SPACE
WORKAREA DSECT
SAVEAREA DS    18F
CPPLPTR  DS    F
ERRLIST  DS    H,10CL8        UP TO 10 DDNAMES THAT FAILED
ERRLISTL EQU   *-ERRLIST
DAPB     DS    0F
         ORG   DAPB+DAPB18L
DAPL     DS     5F
ECB      DS     F
FMMSG    DS    0CL78           MESSAGE TO USER
FMDDN    DS    CL8             DDNAME
FMB1     DS    CL1
FMDSN    DS    CL44            DSNAME
FMB2     DS    CL1
FMVOL    DS    CL6             VOL SER (IF DASD)
FMB3     DS    CL1
FMTEXT   DS    CL17            ACTION CODE
MYDFPARM DS    5F  USED BY DAIRFAIL
MYDFREGS DS    F   USED BY DAIRFAIL
MYDFRC   DS    F   USED BY DAIRFAIL
MYJEFF02 DS    F   USED BY DAIRFAIL
MYDFID   DS    H   USED BY DAIRFAIL
         DS    0D
LDYNAMIC EQU   *-WORKAREA
         SPACE
         EJECT
         IKJDAP18
         SPACE 3
         IKJEFFDF DFDSECT=YES
         SPACE
         PRINT NOGEN
         SPACE
         IKJCPPL
         SPACE 3
DSAB     IHADSAB
         SPACE 3
MAPJFCB  DSECT
         IEFJFCBN LIST=YES
         SPACE 3
         IEFTIOT1
         EJECT
         IEFUCBOB                                                JDM1
         EJECT
         CVT   DSECT=YES,LIST=YES                                JDM1
         EJECT
         IKJTCB                                                  JDM1
         EJECT
         IEZJSCB                                                 JDM1
         EJECT
*----------------------------------------------------------------JDM3-*
*        IHAQDB DSECT=YES    THIS MACRO WAS FOUND IN AN OLD      JDM3
*                            'SYS1.APVTMACS', 1986 VINTAGE.      JDM3
*                            DON'T LIKE TO CODE MACROS INLINE    JDM3
*                            BUT THIS ONE IS AN EXCEPTION.       JDM3
*----------------------------------------------------------------JDM3-*
*/*  OS/VS2 RELEASE 2, 08/02/72, LEVEL=1                         JDM3*/ 00650002
*----------------------------------------------------------------JDM3-*
QDB      DSECT                                                   JDM3   01200002
QDBQDB   DS    CL4 -          ACRONYM IN EBCDIC -QDB-            JDM3   01550002
QDBATTR  DS    BL2 -          QUEUE ATTRIBUTES                   JDM3   01600002
QDBRV001 DS    H -            RESERVED                           JDM3   01650002
QDBNELMS DS    F -            NUMBER OF ELEMENTS ON QUEUE        JDM3   01700002
QDBFELMP DS    A -            POINTER TO FIRST ELEMENT           JDM3   01750002
QDBLELMP DS    A -            POINTER TO LAST ELEMENT            JDM3   01800002
QDBFPTDS DS    H -            FORWARD POINTER DISPLACEMENT       JDM3   01850002
QDBBPTDS DS    H -            BACKWARD POINTER DISPLACEMENT      JDM3   01900002
QDBPRSZ  DS    H -            PRIORITY FIELD SIZE                JDM3   01950002
QDBPRDS  DS    H -            PRIORITY FIELD DISPLACEMENT        JDM3   02000002
QDBRV002 DS    A -            RESERVED                           JDM3   02050002
         END   FREEALL
//LKED.SYSLMOD DD DSN=SYS2.CMDLIB,DISP=SHR                              00120000
//LKED.SYSIN DD *                                                       00130000
 ALIAS FA                                                               00140000
 NAME FREEALL(R)                                                        00150000
/*                                                                      00160000
//HELP    EXEC PGM=IEBGENER                                             00170000
//SYSIN    DD  *                                                        00180000
  GENERATE MAXNAME=2                                                    00190000
  MEMBER NAME=(FREEALL,FA)                                              00200000
//SYSPRINT DD  SYSOUT=*                                                 00210000
//SYSUT2   DD  DSN=SYS2.HELP,DISP=SHR                                   00220000
//SYSUT1   DD  *                                                        00230000
)F FUNCTION -                                                           00020000
  THE FREEALL COMMAND IS USED TO FREE ALL DYNAMICALLY ALLOCATED         00030000
  DATA SETS WHICH HAVE BEEN ALLOCATED BY A GIVEN TSO USER.              00040000
)X SYNTAX -                                                             00050000
         FREEALL                                                        00060000
  ALIAS   -  FA                                                         00070000
  NOTES   -  THERE ARE NO OPERANDS TO THE FREEALL COMMAND.              00080000
          -  THE FREEALL COMMAND WILL FREE ALL DATA SETS WHICH:         00090000
             1. HAVE BEEN DYNAMICALLY ALLOCATED.                        00100000
             2. ARE NOT CURRENTLY IN USE.                               00110000
             3. ARE NOT CURRENTLY OPEN.                                 00120000
             4. ARE NOT ALLOCATED TO DDNAME=SYSPROC                     00121001
             5. ARE NOT ALLOCATED TO DDNAME=ISPPROF                     00122002
)O OPERANDS - THERE ARE NO OPERANDS TO THE FREEALL COMMAND.             00130000
//                                                                      00250000
