//ICKDSF   JOB (SYS),'INITIALIZE NEW DASD ',
//             CLASS=S,MSGCLASS=A
//ICKDSF EXEC PGM=ICKDSF13,REGION=4M
//* ***************************************************************** *
//* * Initialize 3390 @ X'390' for new VS2RES (system residence)      *
//* *            3390 @ X'391' for new VS2MNT (DLIBs and SMP)         *
//* ***************************************************************** *
//SYSPRINT DD  SYSOUT=*
//IPLTEXT  DD  DSN=SYS1.ASAMPLIB(IEAIPL00),DISP=SHR,
//             UNIT=3350,VOL=SER=SMP000
//SYSIN    DD  *
  INIT UNIT(390) -
               VERIFY(111111) -
               OWNER(HERCULES) -
               VOLID(VS2RES) -
               VTOC(0,1,29) -
               IPLDD(IPLTEXT)
  INIT UNIT(391) -
               VERIFY(222222) -
               OWNER(HERCULES) -
               VOLID(VS2MNT) -
               VTOC(0,1,29)
//ICKDSF EXEC PGM=ICKDSF,REGION=4M
//* ***************************************************************** *
//* * Initialize 3350 @ X'350' for new PAGES0 (paging datasets)       *
//* *            3350 @ X'351' for new JES200 - and -                 *
//* *            3350 @ X'352' for new JES201 - and -                 *
//* *            3350 @ X'353' for new JES202 (JES2 spool volumes)    *
//* ***************************************************************** *
//SYSPRINT DD  SYSOUT=*
//SYSIN    DD  *
  INIT UNITADDRESS(350) VERIFY(333333) -
               VOLID(PAGES0) OWNER(HERCULES) -
               VTOC(0,1,1)
  INIT UNITADDRESS(351) VERIFY(444444) -
               VOLID(JES200) OWNER(HERCULES) -
               VTOC(0,1,29)
  INIT UNITADDRESS(352) VERIFY(555555) -
               VOLID(JES201) OWNER(HERCULES) -
               VTOC(0,1,29)
  INIT UNITADDRESS(353) VERIFY(666666) -
               VOLID(JES202) OWNER(HERCULES) -
               VTOC(0,1,29)
//*
//IEBGENER EXEC PGM=IEBGENER,COND=(0,NE)                         
//*                                                                     
//* ***************************************************************** * 
//* If ICKDSF RC=0000, submit continuation job to internal reader.    * 
//* ***************************************************************** * 
//*                                                                     
//SYSPRINT DD  DUMMY                                                    
//SYSIN    DD  DUMMY                                                    
//SYSUT1   DD  DATA,DLM='><'                                            
//ICKDSF   JOB (SYS),'CREATE NEW CATALOG  ',
//             CLASS=S,MSGCLASS=A
//*                                                                     
//********************************************************************* 
//* Continuation from ICKDSF - This job will be submitted to the      *
//* internal reader if all disk initialization succeeded.             * 
//********************************************************************* 
//*                                                                     
//********************************************************************* 
//* VARY new DASD online and MOUNT as PRIVATE volumes.                * 
//********************************************************************* 
//*                                                                     
// V (350,351,352,353,390,391),ONLINE                                           
// M 350,VOL=(SL,PAGES0),USE=PRIVATE                                    
// M 351,VOL=(SL,JES200),USE=PRIVATE                                    
// M 352,VOL=(SL,JES201),USE=PRIVATE                                    
// M 353,VOL=(SL,JES202),USE=PRIVATE                                    
// M 390,VOL=(SL,VS2RES),USE=PRIVATE                                    
// M 391,VOL=(SL,VS2MNT),USE=PRIVATE                                    
//*                                                                     
//IEFBR14  EXEC PGM=IEFBR14                                             
//*                                                                     
//IDCAMS   EXEC PGM=IDCAMS,REGION=4M
//*
//* ***************************************************************** *
//* Define a User Catalog on VS2RES, cataloged in the working system  *
//* Master Catalog.  It will become the Master Catalog on the target  *
//* system residing on 3390 DASD.                                     *
//* ***************************************************************** *
//*
//SYSPRINT DD  SYSOUT=*
//SYSUT1   DD  UNIT=3390,VOL=SER=VS2RES,DISP=OLD
//SYSIN    DD  *

  /* REMOVE SYS1.VS2RES.MASTER.CATALOG FROM THE WORKING SYSTEM.  */
  /* THIS IS TO ALLOW FOR RESTART OF THIS PROCESS.               */

  EXPORT SYS1.VS2RES.MASTER.CATALOG DISCONNECT

  /* SET THE LASTCC AND MAXCC TO 0000 IN CASE THE EXPORT FAILED  */

  SET LASTCC = 0
  SET  MAXCC = 0

  /* DEFINE SYS1.VS2RES.MASTER.CATALOG                          */

  DEFINE USERCATALOG (                 -
               NAME(SYS1.VS2RES.MASTER.CATALOG) -
               FILE(SYSUT1)            -
               VOLUME(VS2RES)          -
               CYLINDERS(30)           -
               BUFFERSPACE(8192) )

//*         End of jobstream submitted by ICKDSF                 
><
//SYSUT2   DD  SYSOUT=(A,INTRDR)                                        
//*        End of primary ICKDSF                                        
//
