//SYS3390  JOB (SYS),'MIGRATE SYS TO 3390 ',
//             CLASS=S,MSGCLASS=A,TIME=1440
//* *-----------------------------------------------------------------*
//* * 3390 volume VS2RES is empty and ready to receive datasets. This
//* * volume contains the IPL bootstrap program, and will be the
//* * System Residence volume.
//* * 3390 volume VS2MNT is empty and ready to receive datasets. This
//* * volume will contain Distribution Libraries and SMP datasets.
//* *
//* * 1) IEBCOPY is used to copy non-load module library contents.
//* * 2) ZZRELINK is used to copy load module library contents.
//* *    NOTE that some ZZRELINK steps issue messages that IEBCOPY is
//* *    being used instead of re-link-editing particular members.
//* *    As always, when system component modules are link edited,
//* *    a return code of 0004 is expected and normal.
//* * 3) TSO in batch - ACCOUNT and SYNC commands - is used to
//* *    initialize SYS1.BRODCAST.
//* * 4) IEBGENER is used to initialize system dump datasets -
//* *    SYS1.DUMP00, SYS1.DUMP01, SYS1.DUMP02.
//* * 5) IFASMFDP is used to initialize SMF recording datasets -
//* *    SYS1.MANX, SYS1.MANY.
//* * 6) IEBDG is used to modify the SYSCATLG member of SYS1.NUCLEUS
//* *    to point to the new Master Catalog.
//* * 7) IFCDIP00 is used to initialize the equipment check error and
//* *    event log dataset - SYS1.LOGREC.
//* * 8) Update SYS1.PROCLIB(SMFDUMP) to change DEVT and VOLSER for
//* *    datasets receiving SMF data when SYS1.MANX/SYS1.MANY fill.
//* * 9) Update SYS1.PARMLIB(IEAAPF00) to alter VOLSERs on 3 datasets.
//* *10) Update SYS1.PARMLIB(JES2PM00) to alter VOLSER of JES2 check- 
//* *    point and spool datasets, and increase the number of spool   
//* *       volumes.                                                  
//* *    Update SYS1.PARMLIB(VATLST00) to update all changed VOLSER   
//* *       and device types.                                         
//* *11) Allocate JES2 checkpoint and spool datasets on volumes
//* *    JES200, JES201, AND JES202.
//* *12) IDCAMS is used to:                         
//* *       add entries to the catalog on VS2RES for all datasets
//* *          which have been copied/created in this job;
//* *       a model DSCB is created for SYS1.SMF.DATA and a
//* *          GENERATION DATA GROUP is created for it;
//* *       IMPORT/CONNECT User Catalogs on SYSCPK, PUB000, AND
//* *          PUB001; then define ALIASES to these catalogs;
//* *       Define a VSAM DATASPACE on VS2RES; then DEFINE STGINDEX;
//* *       Define 3 PAGE datasets on VOLUME PAGES0;
//* *       Add a password to SYS1.VS2RES.MASTER.CATALOG;
//* *       List the contents of SYS1.VS2RES.MASTER.CATALOG.
//* *-----------------------------------------------------------------*
/*JOBPARM LINES=500
//JOBCAT   DD  DISP=SHR,DSN=SYS1.VS2RES.MASTER.CATALOG
//*
//ZZRELINK PROC LIB=,HLQ='SYS1',TRKS=,DIR=,VI=,VO=
//ZZRELINK EXEC PGM=ZZRELINK,REGION=4096K,PARM=LIST
//SYSPRINT  DD SYSOUT=*,DCB=(RECFM=FB,LRECL=121,BLKSIZE=121)
//INLIB     DD DISP=SHR,UNIT=3350,VOL=SER=&VI.,DSN=&HLQ..&LIB.
//OUTLIB    DD DISP=(,KEEP),DSN=&HLQ..&LIB.,
//             UNIT=3390,VOL=SER=&VO.,LABEL=EXPDT=99365,
//             SPACE=(TRK,(&TRKS.,,&DIR.)),
//             DCB=(RECFM=U,BLKSIZE=32760)
//SYSUT1    DD UNIT=3390,SPACE=(TRK,(96,24)),VOL=SER=PUB001
//SYSUT2    DD UNIT=3390,SPACE=(TRK,(96,24)),VOL=SER=PUB001
//SYSUT3    DD UNIT=3390,SPACE=(TRK,(96,24)),VOL=SER=PUB001
//SYSLOUT   DD SYSOUT=*
//SYSIN     DD DISP=(OLD,PASS),DSN=&&ZZCMD
//         PEND
//*
//* Step S1: IEBGENER is used to put the control card for ZZRELINK into
//* a temporary dataset. It is read by all ZZRELINK steps that follow.
//*
//S1       EXEC PGM=IEBGENER
//*
//SYSPRINT  DD DUMMY
//SYSIN     DD DUMMY
//SYSUT1    DD *
  LINK INDD=INLIB,OUTDD=OUTLIB
//SYSUT2    DD DISP=(,PASS),DSN=&&ZZCMD,
//             UNIT=SYSDA,SPACE=(TRK,(1))
//*
//* Step S2: IEBCOPY copies all non-load module library contents
//*
//S2       EXEC PGM=IEBCOPY,REGION=1M
//*
//SYSPRINT  DD SYSOUT=*
//SYSUT3    DD UNIT=3390,SPACE=(TRK,(80,40)),VOL=SER=PUB001
//IGENLIB   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AGENLIB
//OGENLIB   DD DISP=(,KEEP),DSN=SYS1.AGENLIB,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(93,,49)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IAHELP    DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AHELP
//OAHELP    DD DISP=(,KEEP),DSN=SYS1.AHELP,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(25,,20)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IIMAGE    DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AIMAGE
//OIMAGE    DD DISP=(,KEEP),DSN=SYS1.AIMAGE,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(70,,4)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IAMACLI   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AMACLIB
//OAMACLI   DD DISP=(,KEEP),DSN=SYS1.AMACLIB,
//             UNIT=3390,VOL=SER=VS2MNT,
//             SPACE=(TRK,(188,,38)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IMODGEN   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AMODGEN
//OMODGEN   DD DISP=(,KEEP),DSN=SYS1.AMODGEN,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(123,,58)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IAPARMLI  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.APARMLIB
//OAPARMLI  DD DISP=(,KEEP),DSN=SYS1.APARMLIB,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(2,,4)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IAPROCLI  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.APROCLIB
//OAPROCLI  DD DISP=(,KEEP),DSN=SYS1.APROCLIB,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(2,,8)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IPVTMACS  DD DISP=SHR,DSN=SYS1.APVTMACS,UNIT=3350,VOL=SER=MVS000
//OPVTMACS  DD DSN=SYS1.APVTMACS,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(66,,12))
//IASAMPLI  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.ASAMPLIB
//OASAMPLI  DD DISP=(,KEEP),DSN=SYS1.ASAMPLIB,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(29,,8)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ITCAMMAC  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.ATCAMMAC
//OTCAMMAC  DD DISP=(,KEEP),DSN=SYS1.ATCAMMAC,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(34,,28)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ITSOMAC   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.ATSOMAC
//OTSOMAC   DD DISP=(,KEEP),DSN=SYS1.ATSOMAC,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(36,,20)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IAUADS    DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.AUADS
//OAUADS    DD DISP=(,KEEP),DSN=SYS1.AUADS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(1,,1)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ICMDPROC  DD DISP=SHR,DSN=SYS1.CMDPROC,UNIT=3350,VOL=SER=MVS000
//OCMDPROC  DD DSN=SYS1.CMDPROC,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(102,,20))
//IHASPSRC  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.HASPSRC
//OHASPSRC  DD DISP=(,KEEP),DSN=SYS1.HASPSRC,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(233,,40)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//IHELP1    DD DISP=SHR,DSN=SYS1.HELP,UNIT=3350,VOL=SER=MVSRES
//OHELP1    DD DSN=SYS1.HELP,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,14))
//IINDMAC   DD DISP=SHR,DSN=SYS1.INDMAC,UNIT=3350,VOL=SER=MVSRES
//OINDMAC   DD DISP=(,KEEP),DSN=SYS1.INDMAC,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,14))
//IMACLIB   DD DISP=SHR,DSN=SYS1.MACLIB,UNIT=3350,VOL=SER=MVSRES
//OMACLIB   DD DISP=(,KEEP),DSN=SYS1.MACLIB,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(270,,148))
//IPARMLIB  DD DISP=SHR,DSN=SYS1.PARMLIB,UNIT=3350,VOL=SER=MVSRES
//OPARMLIB  DD DISP=(,KEEP),DSN=SYS1.PARMLIB,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=F,BLKSIZE=80),
//             SPACE=(TRK,(48,,10),,CONTIG)
//IPROCLI1  DD DISP=SHR,DSN=SYS1.PROCLIB,UNIT=3350,VOL=SER=MVSRES
//OPROCLI1  DD DISP=(,KEEP),DSN=SYS1.PROCLIB,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,14))
//ISAMPLIB  DD DISP=SHR,DSN=SYS1.SAMPLIB,UNIT=3350,VOL=SER=MVSRES
//OSAMPLIB  DD DISP=(,KEEP),DSN=SYS1.SAMPLIB,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(225,,10))
//ISMPACDS  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.SMPACDS
//OSMPACDS  DD DISP=(,KEEP),DSN=SYS1.SMPACDS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(413,,4000)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ISMPACRQ  DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.SMPACRQ
//OSMPACRQ  DD DISP=(,KEEP),DSN=SYS1.SMPACRQ,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(8,,32)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ISMPCDS   DD DISP=SHR,DSN=SYS1.SMPCDS,UNIT=3350,VOL=SER=SMP000
//OSMPCDS   DD DISP=(,KEEP),DSN=SYS1.SMPCDS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(780,,4000))
//ISMPCRQ   DD DISP=SHR,DSN=SYS1.SMPCRQ,UNIT=3350,VOL=SER=SMP000
//OSMPCRQ   DD DISP=(,KEEP),DSN=SYS1.SMPCRQ,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(150,,100))
//ISMPMTS   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.SMPMTS
//OSMPMTS    DD DISP=(,KEEP),DSN=SYS1.SMPMTS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(24,,5)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ISMPPTS   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.SMPPTS
//OSMPPTS   DD DISP=(,KEEP),DSN=SYS1.SMPPTS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(1253,,618)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ISMPSCDS  DD DISP=SHR,DSN=SYS1.SMPSCDS,UNIT=3350,VOL=SER=SMP000
//OSMPSCDS  DD DISP=(,KEEP),DSN=SYS1.SMPSCDS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(28,,60))
//ISMPSTS   DD DISP=SHR,UNIT=3350,VOL=SER=SMP000,DSN=SYS1.SMPSTS
//OSMPSTS   DD DISP=(,KEEP),DSN=SYS1.SMPSTS,
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             SPACE=(TRK,(630,,11)),
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920)
//ITCOMMAC  DD DISP=SHR,DSN=SYS1.TCOMMAC,UNIT=3350,VOL=SER=MVSRES
//OTCOMMAC  DD DISP=(,KEEP),DSN=SYS1.TCOMMAC,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(20,,7))
//IUADS     DD DISP=SHR,DSN=SYS1.UADS,UNIT=3350,VOL=SER=MVSRES
//OUADS     DD DISP=(,KEEP),DSN=SYS1.UADS,
//             UNIT=3390,VOL=SER=VS2RES,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=800),
//             SPACE=(CYL,(1,,10))
//IUMODCNT  DD DISP=SHR,DSN=SYS1.UMODCNTL,UNIT=3350,VOL=SER=SMP000
//OUMODCNT  DD DSN=SYS1.UMODCNTL,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,10))
//IUMODMAC  DD DISP=SHR,DSN=SYS1.UMODMAC,UNIT=3350,VOL=SER=SMP000
//OUMODMAC  DD DSN=SYS1.UMODMAC,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,10))
//IUMODOBJ  DD DISP=SHR,DSN=SYS1.UMODOBJ,UNIT=3350,VOL=SER=SMP000
//OUMODOBJ  DD DSN=SYS1.UMODOBJ,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(45,,10))
//IUMODSRC  DD DISP=SHR,DSN=SYS1.UMODSRC,UNIT=3350,VOL=SER=SMP000
//OUMODSRC  DD DSN=SYS1.UMODSRC,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2MNT,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(246,,10))
//IVTAMLST  DD DISP=SHR,DSN=SYS1.VTAMLST,UNIT=3350,VOL=SER=MVS000
//OVTAMLST  DD DISP=(,KEEP),DSN=SYS1.VTAMLST,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(15,,5))
//IVTAMSRC  DD DISP=SHR,DSN=SYS1.VTAMSRC,UNIT=3350,VOL=SER=MVS000
//OVTAMSRC  DD DISP=(,KEEP),DSN=SYS1.VTAMSRC,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(15,,5))
//ICONTROL  DD DISP=SHR,DSN=SYS2.CONTROL,UNIT=3350,VOL=SER=MVS000
//OCONTROL  DD DSN=SYS2.CONTROL,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(30,,20))
//IHELP2    DD DISP=SHR,DSN=SYS2.HELP,UNIT=3350,VOL=SER=MVS000
//OHELP2    DD DSN=SYS2.HELP,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(60,,20))
//IPROCLI2  DD DISP=SHR,DSN=SYS2.PROCLIB,UNIT=3350,VOL=SER=MVS000
//OPROCLI2  DD DSN=SYS2.PROCLIB,DISP=(,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=27920),
//             SPACE=(TRK,(150,,50))
//SYSIN     DD *
  COPY INDD=IGENLIB,OUTDD=OGENLIB
  COPY INDD=IAHELP,OUTDD=OAHELP
  COPY INDD=IIMAGE,OUTDD=OIMAGE
  COPY INDD=IAMACLI,OUTDD=OAMACLI
  COPY INDD=IMODGEN,OUTDD=OMODGEN
  COPY INDD=IAPARMLI,OUTDD=OAPARMLI
  COPY INDD=IAPROCLI,OUTDD=OAPROCLI
  COPY INDD=IPVTMACS,OUTDD=OPVTMACS
  COPY INDD=IASAMPLI,OUTDD=OASAMPLI
  COPY INDD=ITCAMMAC,OUTDD=OTCAMMAC
  COPY INDD=ITSOMAC,OUTDD=OTSOMAC
  COPY INDD=IAUADS,OUTDD=OAUADS
  COPY INDD=ICMDPROC,OUTDD=OCMDPROC
  COPY INDD=IHASPSRC,OUTDD=OHASPSRC
  COPY INDD=IHELP1,OUTDD=OHELP1
  COPY INDD=IINDMAC,OUTDD=OINDMAC
  COPY INDD=IMACLIB,OUTDD=OMACLIB
  COPY INDD=IPARMLIB,OUTDD=OPARMLIB
  COPY INDD=IPROCLI1,OUTDD=OPROCLI1
  COPY INDD=ISAMPLIB,OUTDD=OSAMPLIB
  COPY INDD=ISMPACDS,OUTDD=OSMPACDS
  COPY INDD=ISMPACRQ,OUTDD=OSMPACRQ
  COPY INDD=ISMPCDS,OUTDD=OSMPCDS
  COPY INDD=ISMPCRQ,OUTDD=OSMPCRQ
  COPY INDD=ISMPMTS,OUTDD=OSMPMTS
  COPY INDD=ISMPPTS,OUTDD=OSMPPTS
  COPY INDD=ISMPSCDS,OUTDD=OSMPSCDS
  COPY INDD=ISMPSTS,OUTDD=OSMPSTS
  COPY INDD=ITCOMMAC,OUTDD=OTCOMMAC
  COPY INDD=IUADS,OUTDD=OUADS
  COPY INDD=IUMODCNT,OUTDD=OUMODCNT
  COPY INDD=IUMODMAC,OUTDD=OUMODMAC
  COPY INDD=IUMODOBJ,OUTDD=OUMODOBJ
  COPY INDD=IUMODSRC,OUTDD=OUMODSRC
  COPY INDD=IVTAMLST,OUTDD=OVTAMLST
  COPY INDD=IVTAMSRC,OUTDD=OVTAMSRC
  COPY INDD=ICONTROL,OUTDD=OCONTROL
  COPY INDD=IHELP2,OUTDD=OHELP2
  COPY INDD=IPROCLI2,OUTDD=OPROCLI2
//*
//* Steps S3 THROUGH S50: ZZRELINK calls the Link Editor (and in a
//* few cases IEBCOPY) to copy load module library contents
//*
//S3       EXEC ZZRELINK,LIB=ACMDLIB,TRKS=29,DIR=37,
//             VI=SMP000,VO=VS2MNT
//S4       EXEC ZZRELINK,LIB=ALPALIB,TRKS=4,DIR=8,
//             VI=SMP000,VO=VS2MNT
//S5       EXEC ZZRELINK,LIB=AOS00,TRKS=3,DIR=4,
//             VI=SMP000,VO=VS2MNT
//S6       EXEC ZZRELINK,LIB=AOS03,TRKS=9,DIR=8,
//             VI=SMP000,VO=VS2MNT
//S7       EXEC ZZRELINK,LIB=AOS04,TRKS=5,DIR=5,
//             VI=SMP000,VO=VS2MNT
//S8       EXEC ZZRELINK,LIB=AOS05,TRKS=2,DIR=2,
//             VI=SMP000,VO=VS2MNT
//S9       EXEC ZZRELINK,LIB=AOS06,TRKS=12,DIR=18,
//             VI=SMP000,VO=VS2MNT
//S10      EXEC ZZRELINK,LIB=AOS07,TRKS=12,DIR=18,
//             VI=SMP000,VO=VS2MNT
//S11      EXEC ZZRELINK,LIB=AOS11,TRKS=7,DIR=10,
//             VI=SMP000,VO=VS2MNT
//S12      EXEC ZZRELINK,LIB=AOS12,TRKS=42,DIR=45,
//             VI=SMP000,VO=VS2MNT
//S13      EXEC ZZRELINK,LIB=AOS20,TRKS=14,DIR=23,
//             VI=SMP000,VO=VS2MNT
//S14      EXEC ZZRELINK,LIB=AOS21,TRKS=78,DIR=105,
//             VI=SMP000,VO=VS2MNT
//S15      EXEC ZZRELINK,LIB=AOS24,TRKS=29,DIR=50,
//             VI=SMP000,VO=VS2MNT
//S16      EXEC ZZRELINK,LIB=AOS26,TRKS=48,DIR=74,
//             VI=SMP000,VO=VS2MNT
//S17      EXEC ZZRELINK,LIB=AOS29,TRKS=6,DIR=5,
//             VI=SMP000,VO=VS2MNT
//S18      EXEC ZZRELINK,LIB=AOS32,TRKS=46,DIR=70,
//             VI=SMP000,VO=VS2MNT
//S19      EXEC ZZRELINK,LIB=AOSA0,TRKS=31,DIR=36,
//             VI=SMP000,VO=VS2MNT
//S20      EXEC ZZRELINK,LIB=AOSA1,TRKS=1,DIR=1,
//             VI=SMP000,VO=VS2MNT
//S21      EXEC ZZRELINK,LIB=AOSB0,TRKS=2,DIR=2,
//             VI=SMP000,VO=VS2MNT
//S22      EXEC ZZRELINK,LIB=AOSB3,TRKS=53,DIR=79,
//             VI=SMP000,VO=VS2MNT
//S23      EXEC ZZRELINK,LIB=AOSBN,TRKS=1,DIR=1,
//             VI=SMP000,VO=VS2MNT
//S24      EXEC ZZRELINK,LIB=AOSC2,TRKS=1,DIR=2,
//             VI=SMP000,VO=VS2MNT
//S25      EXEC ZZRELINK,LIB=AOSC5,TRKS=84,DIR=109,
//             VI=SMP000,VO=VS2MNT
//S26      EXEC ZZRELINK,LIB=AOSC6,TRKS=5,DIR=8,
//             VI=SMP000,VO=VS2MNT
//S27      EXEC ZZRELINK,LIB=AOSCA,TRKS=3,DIR=3,
//             VI=SMP000,VO=VS2MNT
//S28      EXEC ZZRELINK,LIB=AOSCD,TRKS=52,DIR=220,
//             VI=SMP000,VO=VS2MNT
//S29      EXEC ZZRELINK,LIB=AOSCE,TRKS=9,DIR=13,
//             VI=SMP000,VO=VS2MNT
//S30      EXEC ZZRELINK,LIB=AOSD0,TRKS=92,DIR=139,
//             VI=SMP000,VO=VS2MNT
//S31      EXEC ZZRELINK,LIB=AOSD7,TRKS=6,DIR=9,
//             VI=SMP000,VO=VS2MNT
//S32      EXEC ZZRELINK,LIB=AOSD8,TRKS=17,DIR=117,
//             VI=SMP000,VO=VS2MNT
//S33      EXEC ZZRELINK,LIB=AOSG0,TRKS=6,DIR=11,
//             VI=SMP000,VO=VS2MNT
//S34      EXEC ZZRELINK,LIB=AOSH1,TRKS=2,DIR=1,
//             VI=SMP000,VO=VS2MNT
//S35      EXEC ZZRELINK,LIB=AOSH3,TRKS=9,DIR=4,
//             VI=SMP000,VO=VS2MNT
//S36      EXEC ZZRELINK,LIB=AOST3,TRKS=14,DIR=22,
//             VI=SMP000,VO=VS2MNT
//S37      EXEC ZZRELINK,LIB=AOST4,TRKS=21,DIR=28,
//             VI=SMP000,VO=VS2MNT
//S38      EXEC ZZRELINK,LIB=AOSU0,TRKS=107,DIR=95,
//             VI=SMP000,VO=VS2MNT
//S39      EXEC ZZRELINK,LIB=CMDLIB,TRKS=44,DIR=58,
//             VI=MVSRES,VO=VS2RES
//S40      EXEC ZZRELINK,LIB=DCMLIB,TRKS=101,DIR=6,
//             VI=MVSRES,VO=VS2RES
//S41      EXEC ZZRELINK,LIB=IMAGELIB,TRKS=10,DIR=7,
//             VI=MVSRES,VO=VS2RES
//S42      EXEC ZZRELINK,LIB=LINKLIB,TRKS=202,DIR=657,
//             VI=MVSRES,VO=VS2RES
//S43      EXEC ZZRELINK,LIB=LPALIB,TRKS=230,DIR=300,
//             VI=MVSRES,VO=VS2RES
//S44      EXEC ZZRELINK,LIB=NUCLEUS,TRKS=55,DIR=7,
//             VI=MVSRES,VO=VS2RES
//S45      EXEC ZZRELINK,LIB=SVCLIB,TRKS=30,DIR=18,
//             VI=MVSRES,VO=VS2RES
//S46      EXEC ZZRELINK,LIB=TELCMLIB,TRKS=40,DIR=38,
//             VI=MVSRES,VO=VS2RES
//S47      EXEC ZZRELINK,LIB=VTAMLIB,TRKS=40,DIR=35,
//             VI=MVSRES,VO=VS2RES
//S48      EXEC ZZRELINK,LIB=UMODLIB,TRKS=30,DIR=10,
//             VI=SMP000,VO=VS2RES
//S49      EXEC ZZRELINK,HLQ='SYS2',LIB=CMDLIB,TRKS=202,DIR=100,
//             VI=MVS000,VO=VS2RES
//S50      EXEC ZZRELINK,HLQ='SYS2',LIB=LINKLIB,TRKS=300,DIR=300,
//             VI=MVS000,VO=VS2RES
//*
//* Step S51: Initialize SYS1.BRODCAST dataset.
//*
//S51      EXEC PGM=IKJEFT01,REGION=1024K,DYNAMNBR=50
//*
//SYSPRINT  DD SYSOUT=*
//SYSTSPRT  DD SYSOUT=*
//SYSTERM   DD SYSOUT=*
//SYSLBC    DD DISP=(,KEEP),DSN=SYS1.BRODCAST,
//             UNIT=3390,VOL=SER=VS2RES,
//             SPACE=(CYL,(1),,CONTIG)
//SYSUADS   DD DSN=SYS1.UADS,DISP=SHR,UNIT=3390,VOL=SER=VS2RES
//SYSTSIN   DD *
ACCOUNT
SYNC
LIST (*)
END
//*
//* Steps S52 through S54: Create/initialize three system dump
//* datasets.
//*
//S52      EXEC PGM=IEBGENER
//*
//SYSPRINT DD  SYSOUT=*
//SYSIN    DD  DUMMY
//SYSUT1   DD  DUMMY,DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//SYSUT2   DD  DISP=(,KEEP),DSN=SYS1.DUMP00,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             SPACE=(TRK,(303),,CONTIG),
//             DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//S53      EXEC PGM=IEBGENER
//SYSPRINT DD  SYSOUT=*
//SYSIN    DD  DUMMY
//SYSUT1   DD  DUMMY,DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//SYSUT2   DD  DISP=(,KEEP),DSN=SYS1.DUMP01,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             SPACE=(TRK,(303),,CONTIG),
//             DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//S54      EXEC PGM=IEBGENER
//SYSPRINT DD  SYSOUT=*
//SYSIN    DD  DUMMY
//SYSUT1   DD  DUMMY,DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//SYSUT2   DD  DISP=(,KEEP),DSN=SYS1.DUMP02,
//             UNIT=3390,VOL=SER=VS2RES,LABEL=EXPDT=99365,
//             SPACE=(TRK,(303),,CONTIG),
//             DCB=(RECFM=U,LRECL=10,BLKSIZE=10)
//*
//* Steps S55 through S56: Create/initialize SMF recording datasets.
//*
//S55      EXEC PGM=IFASMFDP,REGION=4M
//*
//SYSPRINT DD  SYSOUT=*
//DUMPIN   DD  DISP=(,KEEP),DSN=SYS1.MANX,
//             UNIT=3390,VOL=SER=VS2RES,
//             SPACE=(TRK,(75),,CONTIG),
//             DCB=(RECFM=VBS,LRECL=4096,BLKSIZE=4096)
//DUMPOUT  DD  DUMMY
//SYSIN    DD  *
     INDD(DUMPIN,OPTIONS(CLEAR))
//S56      EXEC PGM=IFASMFDP,REGION=4M
//SYSPRINT DD  SYSOUT=*
//DUMPIN   DD  DISP=(,KEEP),DSN=SYS1.MANY,
//             UNIT=3390,VOL=SER=VS2RES,
//             SPACE=(TRK,(75),,CONTIG),
//             DCB=(RECFM=VBS,LRECL=4096,BLKSIZE=4096)
//DUMPOUT  DD  DUMMY
//SYSIN    DD  *
     INDD(DUMPIN,OPTIONS(CLEAR))
//*
//* Step S57: IEBDG is used to recopy the SYSCATLG member of
//* SYS1.NUCLEUS, changing the Master Catalog volume ID and name.
//*
//S57      EXEC PGM=IEBDG
//*
//SYSPRINT DD  SYSOUT=*
//INDD     DD  DISP=SHR,DSN=SYS1.NUCLEUS(SYSCATLG),
//             UNIT=3350,VOL=SER=MVSRES
//OUTDD    DD  DISP=OLD,DSN=SYS1.NUCLEUS(SYSCATLG),
//             UNIT=3390,VOL=SER=VS2RES
//SYSIN    DD  *
  DSD    OUTPUT=(OUTDD),INPUT=(INDD)
  FD     NAME=ONE,LENGTH=6,STARTLOC=1,PICTURE=6,'VS2RES'
  FD     NAME=TWO,LENGTH=4,STARTLOC=7,FROMLOC=7,INPUT=INDD
  FD     NAME=TRE,LENGTH=44,STARTLOC=11,PICTURE=44,                    C
               'SYS1.VS2RES.MASTER.CATALOG                  '
  FD     NAME=FOR,LENGTH=26,STARTLOC=55,FROMLOC=55,INPUT=INDD
  CREATE NAME=(ONE,TWO,TRE,FOR),INPUT=INDD
  END
//*
//* Step S58: The error/event log dataset is initialized.
//*
//S58      EXEC PGM=IFCDIP00           (SYSGEN JOB5/STEP2)
//*
//SERERDS  DD  DSN=SYS1.LOGREC,DISP=(NEW,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,
//             SPACE=(TRK,(30),,CONTIG)
//*
//* Step S59: library=SYS1.PROCLIB, member=SMFDUMP
//*             alter DSN/VOLSER for SMF dump receiving dataset.
//*
//S59      EXEC PGM=IEBUPDTE
//*
//SYSPRINT DD SYSOUT=*
//SYSUT1   DD DSN=SYS1.PROCLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSUT2   DD DSN=SYS1.PROCLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSIN    DD DATA,DLM='><'
./ CHANGE NAME=SMFDUMP,UPDATE=INPLACE
//DUMPOUT   DD  DSN=SYS1.SMF.DATA(+1),DISP=(NEW,CATLG),                 00000080
//             UNIT=SYSDA,VOL=SER=VS2RES,SPACE=(CYL,(5,1),RLSE)         00000090
./ ENDUP
><
//*
//S60      EXEC PGM=IEBUPDTE
//*
//* Step S60: library=SYS1.PARMLIB, member=IEAAPF00
//*             alter VOLSERs on 3 datasets.
//*
//SYSPRINT DD SYSOUT=*
//SYSUT1   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSUT2   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSIN    DD DATA,DLM='><'
./ CHANGE NAME=IEAAPF00,UPDATE=INPLACE
 SYS1.VTAMLIB VS2RES,         REQUIRED BY MVS                           00000010
 SYS1.INDMAC VS2RES,          REQUIRED BY MVS                           00000020
 SYS2.LINKLIB VS2RES,         USER BATCH LINKLIB                        00000030
./ ENDUP
><
//*
//* Step S61: library=SYS1.PARMLIB, member=JES2PM00
//*             alter checkpoint VOLSER, number of JES2 spool volumes,
//*             and VOLSER of spool volumes.
//*
//S61      EXEC PGM=IEBUPDTE
//*
//SYSPRINT DD SYSOUT=*
//SYSUT1   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSUT2   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSIN    DD DATA,DLM='><'
./ CHANGE NAME=JES2PM00,UPDATE=INPLACE
&CHKPT=JES200                  CHECKPOINT DATASET ON JES200             00000030
&NUMDA=3                       MAX NUMBER OF SPOOL VOLUMES              00000340
&SPOOL=JES200                  SPOOL VOLUME SERIAL                      00001190
./ ENDUP
><
//*
//* Step S62: library=SYS1.PARMLIB, member=VATLST00
//*             replace member to update DASD volumes SER and DEVT.
//*
//S62      EXEC PGM=IEBUPDTE
//*
//SYSPRINT DD SYSOUT=*
//SYSUT1   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSUT2   DD DSN=SYS1.PARMLIB,DISP=OLD,UNIT=3390,VOL=SER=VS2RES
//SYSIN    DD DATA,DLM='><'
./ REPL NAME=VATLST00,LIST=ALL
./ NUMBER NEW1=10,INCR=10
VS2RES,0,2,3390    ,Y        SYSTEM RESIDENCE (PRIVATE)
VS2MNT,0,2,3390    ,Y        DLIBS/SYSTEM MAINTENANCE (PRIVATE)
PAGES0,0,2,3350    ,Y        PAGE DATASETS (PRIVATE)
PUB000,1,2,3380    ,N        PUBLIC DATASETS (PRIVATE)
PUB001,1,2,3390    ,N        PUBLIC DATASETS (PRIVATE)
JES200,0,2,3350    ,Y        JES2 QUEUES (PRIVATE)
JES201,0,2,3350    ,Y        JES2 QUEUES (PRIVATE)
JES202,0,2,3350    ,Y        JES2 QUEUES (PRIVATE)
SYSCPK,1,2,3350    ,N        COMPILER/TOOLS (PRIVATE)
WORK00,1,0,3350    ,N        WORK PACK (STORAGE)
WORK01,1,0,3350    ,N        WORK PACK (STORAGE)
./ ENDUP
><
//*
//* Step S63: Allocate JES2 checkpoint and spool datasets on 3350
//*           volumes JES200, JES201, AND JES202.
//*
//S63      EXEC PGM=IEFBR14
//*
//HASPCKPT DD  DSN=SYS1.HASPCKPT,
//             UNIT=3350,VOL=SER=JES200,DISP=(,KEEP),
//             SPACE=(CYL,(1))
//HASPACE1 DD  DSN=SYS1.HASPACE,
//             UNIT=3350,VOL=SER=JES200,DISP=(,KEEP),
//             SPACE=(CYL,(553))
//HASPACE2 DD  DSN=SYS1.HASPACE,
//             UNIT=3350,VOL=SER=JES201,DISP=(,KEEP),
//             SPACE=(CYL,(554))
//HASPACE3 DD  DSN=SYS1.HASPACE,
//             UNIT=3350,VOL=SER=JES202,DISP=(,KEEP),
//             SPACE=(CYL,(554))
//*
//* Step S64: All datasets created/copied in steps above will now
//*           have entries entered into the User Catalog which will
//*           become the Master Catalog for the 3390 system on VS2RES.
//*
//*           Other required VSAM objects will be imported/created.
//*
//S64      EXEC PGM=IDCAMS,REGION=4M
//*
//STEPCAT  DD  DISP=SHR,DSN=SYS1.VS2RES.MASTER.CATALOG
//SYSPRINT DD  SYSOUT=*
//MODEL    DD  DSN=SYS1.SMF.DATA,DISP=(NEW,KEEP),
//             UNIT=3390,VOL=SER=VS2RES,SPACE=(TRK,0),
//             DCB=(RECFM=VBS,LRECL=32756,BLKSIZE=32760)
//SYSCPK   DD  UNIT=3350,DISP=OLD,VOL=SER=SYSCPK
//PUB000   DD  UNIT=3380,DISP=OLD,VOL=SER=PUB000
//PUB001   DD  UNIT=3390,DISP=OLD,VOL=SER=PUB001
//STGINDEX DD  UNIT=3390,DISP=OLD,VOL=SER=VS2RES
//PAGE1    DD  UNIT=3350,DISP=OLD,VOL=SER=PAGES0
//PAGE2    DD  UNIT=3350,DISP=OLD,VOL=SER=PAGES0
//PAGE3    DD  UNIT=3350,DISP=OLD,VOL=SER=PAGES0
//SYSIN    DD  *
  DEFINE NONVSAM (NAME(SYS1.ACMDLIB)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AGENLIB)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AHELP)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AIMAGE)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.ALPALIB)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.APVTMACS) VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AMACLIB)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AMODGEN)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS00)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS03)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS04)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS05)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS06)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS07)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS11)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS12)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS20)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS21)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS24)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS26)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS29)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOS32)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSA0)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSA1)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSB0)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSB3)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSBN)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSC2)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSC5)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSC6)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSCA)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSCD)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSCE)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSD0)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSD7)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSD8)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSG0)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSH1)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSH3)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOST3)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOST4)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AOSU0)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.APARMLIB) VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.APROCLIB) VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.ASAMPLIB) VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.ATCAMMAC) VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.ATSOMAC)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.AUADS)    VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.BRODCAST) VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.CMDLIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.CMDPROC)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.DCMLIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.DUMP00)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.DUMP01)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.DUMP02)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.HASPSRC)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.HELP)     VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.IMAGELIB) VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.INDMAC)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.LINKLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.LOGREC)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.LPALIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.MACLIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.MANX)     VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.MANY)     VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.NUCLEUS)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.PARMLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.PROCLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SAMPLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPACDS)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPACRQ)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPCDS)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPCRQ)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPMTS)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPPTS)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPSCDS)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SMPSTS)   VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.SVCLIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.TCOMMAC)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.TELCMLIB) VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UADS)     VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UMODCNTL) VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UMODLIB)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UMODMAC)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UMODOBJ)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.UMODSRC)  VOL(VS2MNT) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.VTAMLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.VTAMLST)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS1.VTAMSRC)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS2.CMDLIB)   VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS2.CONTROL)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS2.HELP)     VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS2.LINKLIB)  VOL(VS2RES) DEVT(3390))
  DEFINE NONVSAM (NAME(SYS2.PROCLIB)  VOL(VS2RES) DEVT(3390))

  /* A GENERATION DATA GROUP IS DEFINED TO CONTAIN THE SMF     */
  /* DATA THAT IS OFFLOADED WHEN THE SMF DATA RECORDING        */
  /* DATASETS ARE FILLED                                       */

  DEFINE GENERATIONDATAGROUP (NAME(SYS1.SMF.DATA)           -
                              LIMIT(5) SCRATCH)

  /* IMPORT AND CONNECT USER CATALOG AND DEFINE ALIASES FOR    */
  /* SYSCPK                                                    */

  IMPORT OBJECTS (UCSYSCPK DEVT(3350) VOL(SYSCPK)) CONNECT -
         CATALOG(SYS1.VS2RES.MASTER.CATALOG)

  DEFINE ALIAS (NAME(SYSC) RELATE (UCSYSCPK))

  DEFINE ALIAS (NAME(GCC) RELATE (UCSYSCPK))

  DEFINE ALIAS (NAME (PDPCLIB) RELATE (UCSYSCPK))

  /* IMPORT AND CONNECT USER CATALOG AND DEFINE ALIAS FOR      */
  /* PUB000                                                    */

  IMPORT OBJECTS (UCPUB000 DEVT(3380) VOL(PUB000)) CONNECT -
         CATALOG(SYS1.VS2RES.MASTER.CATALOG)

  DEFINE ALIAS (NAME (PUB000) RELATE (UCPUB000))

  /* DEFINE ALIASES FOR TSO USER ID'S HMVS01 AND HMVS02        */

  DEFINE ALIAS (NAME (HMVS01) RELATE (UCPUB000))
  DEFINE ALIAS (NAME (HMVS02) RELATE (UCPUB000))

  /* IMPORT AND CONNECT USER CATALOG AND DEFINE ALIAS FOR      */
  /* PUB001                                                    */

  IMPORT OBJECTS (UCPUB001 DEVT(3390) VOL(PUB001)) CONNECT -
         CATALOG(SYS1.VS2RES.MASTER.CATALOG)

  DEFINE ALIAS (NAME (PUB001) RELATE (UCPUB001))

  /* DEFINE ALIAS FOR ROB PRIN'S RPF                           */

  DEFINE ALIAS (NAME (RPF) RELATE (UCPUB000))

  /* DEFINE DATASPACE ON VS2RES FOR SYS1.STGINDEX              */

  DEFINE SPACE (VOLUME(VS2RES) FILE(STGINDEX) CYLINDERS(3))

  /* DEFINE SYS1.STGINDEX                                      */

  DEFINE CLUSTER -
              (NAME(SYS1.STGINDEX) -
               FILE(STGINDEX) -
               KEYS(12,8) -
               CYLINDERS(2) -
               BUFFERSPACE(5120) -
               RECORDSIZE(2041,2041) -
               VOLUME(VS2RES) -
               REUSE) -
         DATA (CONTROLINTERVALSIZE(2048)) -
         INDEX (CONTROLINTERVALSIZE(1024))

  /* DEFINE THREE PAGE DATASETS ON VOLUME PAGES0               */

  DEFINE PAGESPACE -
              (NAME(SYS1.PAGELPA) -
               FILE(PAGE1) -
               CYLINDERS(185) -
               VOLUME(PAGES0) -
               UNIQUE)

  DEFINE PAGESPACE -
              (NAME(SYS1.PAGECSA) -
               FILE(PAGE2) -
               CYLINDERS(185) -
               VOLUME(PAGES0) -
               UNIQUE)

  DEFINE PAGESPACE -
              (NAME(SYS1.PAGEL00) -
               FILE(PAGE3) -
               CYLINDERS(184) -
               VOLUME(PAGES0) -
               UNIQUE)

  /* THE LAST MAJOR CHANGE HAS BEEN MADE TO THE FUTURE MASTER  */
  /* CATALOG AT THIS POINT, SO WE WILL ADD AN UPDATE PASSWORD  */
  /* TO MAKE SURE THAT ANY ADDITIONS/DELETIONS/CHANGES TO      */
  /* THE MASTER CATALOG REQUIRE OPERATOR APPROVAL.             */

  ALTER SYS1.VS2RES.MASTER.CATALOG -
        UPDATEPW(SYSPROG)

  /* LIST ALL VSAM AND NON-VSAM OBJECTS IN THE CATALOG         */

  LISTCAT VOLUME CATALOG(SYS1.VS2RES.MASTER.CATALOG)
//
